/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.container;

import com.nyfaria.numismaticoverhaul.owostuff.ui.container.FlowLayout;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.HorizontalAlignment;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Insets;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.ModComponent;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Size;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Sizing;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.VerticalAlignment;
import com.nyfaria.numismaticoverhaul.owostuff.ui.util.MountingHelper;
import java.util.ArrayList;
import org.apache.commons.lang3.mutable.MutableInt;

public class HorizontalFlowLayout
extends FlowLayout {
    protected HorizontalFlowLayout(Sizing horizontalSizing, Sizing verticalSizing) {
        super(horizontalSizing, verticalSizing);
    }

    @Override
    public void layout(Size space) {
        MutableInt layoutWidth = new MutableInt(0);
        MutableInt layoutHeight = new MutableInt(0);
        ArrayList layout = new ArrayList();
        Insets padding = (Insets)this.padding.get();
        Size childSpace = this.calculateChildSpace(space);
        MountingHelper mountState = MountingHelper.mountEarly((x$0, x$1, x$2) -> this.mountChild(x$0, x$1, x$2), this.children, childSpace, child -> {
            layout.add(child);
            child.inflate(childSpace);
            child.mount(this, this.x + padding.left() + ((Insets)child.margins().get()).left() + layoutWidth.intValue(), this.y + padding.top() + ((Insets)child.margins().get()).top());
            Size childSize = child.fullSize();
            layoutWidth.add(childSize.width());
            if (childSize.height() > layoutHeight.intValue()) {
                layoutHeight.setValue(childSize.height());
            }
        });
        this.contentSize = Size.of(layoutWidth.intValue(), layoutHeight.intValue());
        if (((Sizing)this.horizontalSizing.get()).method == Sizing.Method.CONTENT) {
            this.applyHorizontalContentSizing((Sizing)this.horizontalSizing.get());
        }
        if (((Sizing)this.verticalSizing.get()).method == Sizing.Method.CONTENT) {
            this.applyVerticalContentSizing((Sizing)this.verticalSizing.get());
        }
        if (this.verticalAlignment() != VerticalAlignment.TOP) {
            for (ModComponent component : layout) {
                component.setY(component.y() + this.verticalAlignment().align(component.fullSize().height(), this.height - padding.vertical()));
            }
        }
        if (this.horizontalAlignment() != HorizontalAlignment.LEFT) {
            for (ModComponent component : layout) {
                if (this.horizontalAlignment() == HorizontalAlignment.CENTER) {
                    component.setX(component.x() + (this.width - padding.horizontal() - layoutWidth.intValue()) / 2);
                    continue;
                }
                component.setX(component.x() + (this.width - padding.horizontal() - layoutWidth.intValue()));
            }
        }
        mountState.mountLate();
    }
}

